﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Text;
using System.Threading;
using Microsoft.WindowsAzure.Diagnostics;
using Microsoft.WindowsAzure.ServiceRuntime;
using System.ServiceModel;
using HelloService;

namespace HelloWorkerRole
{
    public class WorkerRole : RoleEntryPoint
    {
        public override void Run()
        {
            // This is a sample worker implementation. Replace with your logic.
            Trace.WriteLine("HelloWorkerRole entry point called", "Information");

            var internalEndpoint = RoleEnvironment.CurrentRoleInstance.InstanceEndpoints["MyInternalEndpoint"];
            var wcfAddress = new Uri(String.Format("net.tcp://{0}", internalEndpoint.IPEndpoint.ToString()));
            Trace.WriteLine(wcfAddress.ToString());
            var wcfHost = new ServiceHost(typeof(HelloServiceImpl), wcfAddress);
            var binding = new NetTcpBinding(SecurityMode.None);
            wcfHost.AddServiceEndpoint(typeof(IHelloService), binding, "helloservice");
            try
            {
                wcfHost.Open();
                while (true)
                {
                    Thread.Sleep(10000);
                    Trace.WriteLine("Working", "Information");
                }
            }
            finally
            {
                wcfHost.Close();

            }
        }

        public override bool OnStart()
        {
            //Get the default configuration
            DiagnosticMonitorConfiguration dmc = DiagnosticMonitor.GetDefaultInitialConfiguration();
            //Set the schedule to transfer logs every 10 mins to the storage
            dmc.Logs.ScheduledTransferPeriod = TimeSpan.FromMinutes(10);
            //Start Diagnostics Monitor with the storage account configuration 
            DiagnosticMonitor.Start("DiagnosticsConnectionString", dmc);
            //DiagnosticMonitor.Start("DiagnosticsConnectionString");

            // Restart the role upon all configuration changes
            // Note: To customize the handling of configuration changes, 
            // remove this line and register custom event handlers instead.
            // See the MSDN topic on “Managing Configuration Changes” for further details 
            // (http://go.microsoft.com/fwlink/?LinkId=166357).
            RoleEnvironment.Changing += RoleEnvironmentChanging;

            return base.OnStart();
        }

        //private void RoleEnvironmentChanging(object sender, RoleEnvironmentChangingEventArgs e)
        //{
        //    if (e.Changes.Any(change => change is RoleEnvironmentConfigurationSettingChange))
        //        e.Cancel = true;
        //}

        private void RoleEnvironmentChanging(object sender, RoleEnvironmentChangingEventArgs e)
        {
            if (e.Changes.Any(change => change is RoleEnvironmentConfigurationSettingChange))
                e.Cancel = true;

            foreach (var change in e.Changes)
            {

                var configChange = change as RoleEnvironmentConfigurationSettingChange;

                // Return old value

                if (configChange != null)
                {

                    RoleEnvironment.GetConfigurationSettingValue(

                        configChange.ConfigurationSettingName);

                }

            }

        }
    }
}
